# Global Address Validation Toolkit - Implementation Guide

This Toolkit is designed for developers building international checkout and address capture.
It ships a single cheatsheet table plus machine-friendly helpers to implement safe defaults.

## Files

- `country-format-cheatsheet.(csv|json|xlsx)`
- `required-fields.json` - ISO2 -> boolean required flags for a checkout form
- `types.ts` - TypeScript types for these files
- `templates/checkout-form.html` - reference form template (mobile-first)
- `templates/validation.js` - small helper utilities used by the template

## Recommended defaults

- Treat `conditional` fields as optional UI fields.
- If a user provides a postcode, validate it (when you have a regex rule).
- Never hard-block checkout on a missing regex for lower-confidence countries.

## How to use `required-fields.json`

Use ISO2 (e.g. `US`, `DE`) as the key.

Example (TypeScript):

```ts
import type { RequiredFieldsMatrix } from './types';
import requiredMatrix from './required-fields.json' assert { type: 'json' };

const rules = (requiredMatrix as RequiredFieldsMatrix)['DE'];
if (rules.postcode_required) {
  // Make postcode field required
}
```

## Postcode validation

This Toolkit includes postcode regex deliverables:

- `postcode-regex.json`

[sample truncated]
