// ExampleAddress - reference implementation (browser + Node ESM)
// Uses required-fields.json and (optionally) postcode-regex.json from the Regex pack.

export function normalizeIso2(value) {
  return String(value || '').trim().toUpperCase();
}

export function rulesForCountry(iso2, requiredMatrix) {
  const key = normalizeIso2(iso2);
  const fallback = {
    recipient_name_required: true,
    address_line1_required: true,
    address_line2_required: false,
    district_required: false,
    city_required: true,
    state_region_required: false,
    state_required: false,
    postcode_required: false,
    country_required: true,
  };
  if (!requiredMatrix || typeof requiredMatrix !== 'object') return fallback;
  return Object.assign({}, fallback, requiredMatrix[key] || {});
}

export function validatePostcode(iso2, postcodeValue, regexPack) {
  const code = normalizeIso2(iso2);
  const raw = String(postcodeValue || '').trim();
  if (!raw) return { ok: true, reason: 'empty' };
  if (!regexPack || typeof regexPack !== 'object') {
    return { ok: true, reason: 'no-regex-pack' };
  }
  const rule = regexPack[code] || null;
  if (!rule || !rule.regex) {
    return { ok: true, reason: 'no-regex-rule' };
  }
  try {
    const re = new RegExp(rule.regex);
    return { ok: re.test(raw), reason: 'regex' };
  } catch (e) {
    return { ok: true, reason: 'invalid-regex' };
  }
}
