// ExampleAddress - Global Address Validation Toolkit types

export type RequiredEnum = 'yes' | 'no' | 'conditional';
export type DataConfidence = 'high' | 'medium' | 'low';

export interface CountryFormatRecord {
  country_code: string;
  iso2: string;
  country_name: string;
  field_order_local: string;
  field_order_international: string;
  required_fields: string;
  optional_fields: string;
  state_region_required: RequiredEnum;
  postcode_required: RequiredEnum;
  postcode_pattern_regex: string;
  postcode_examples_10: string;
  landmark_example_name: string;
  landmark_example_local: string;
  script_primary: string;
  latin_fallback_allowed: RequiredEnum;
  data_confidence: DataConfidence;
  notes: string;
}

export type CountryFormatCheatsheet = CountryFormatRecord[];

export interface RequiredFieldsRule {
  recipient_name_required: boolean;
  address_line1_required: boolean;
  address_line2_required: boolean;
  district_required: boolean;
  city_required: boolean;
  state_region_required: boolean;
  state_required: boolean;
  postcode_required: boolean;
  country_required: boolean;
}

export type RequiredFieldsMatrix = Record<string, RequiredFieldsRule>;
